import { DefaultSession, DefaultUser } from "next-auth"
import { JWT as DefaultJWT } from "next-auth/jwt"

declare module "next-auth" {
    interface Session {
        user: {
            role?: string
            id: string
            isApproved?: number
            onboardingComplete?: number
            company?: string
        } & DefaultSession["user"]
        accessToken?: string
        refreshToken?: string
    }

    interface User extends DefaultUser {
        role?: string
        isApproved?: number
        onboardingComplete?: number
        company?: string
    }
}

declare module "next-auth/jwt" {
    interface JWT extends DefaultJWT {
        role?: string
        id?: string
        onboardingComplete?: number
        company?: string
        isApproved?: number
        accessToken?: string
        refreshToken?: string
    }
}
