declare module 'react-easy-crop' {
    import { Component } from 'react';

    export interface Point {
        x: number;
        y: number;
    }

    export interface Area {
        width: number;
        height: number;
        x: number;
        y: number;
    }

    export interface Size {
        width: number;
        height: number;
    }

    export interface CropperProps {
        image?: string;
        video?: string;
        crop: Point;
        zoom?: number;
        rotation?: number;
        aspect?: number;
        minZoom?: number;
        maxZoom?: number;
        cropShape?: 'rect' | 'round';
        cropSize?: Size;
        showGrid?: boolean;
        zoomSpeed?: number;
        onCropChange: (location: Point) => void;
        onZoomChange?: (zoom: number) => void;
        onRotationChange?: (rotation: number) => void;
        onCropComplete?: (croppedArea: Area, croppedAreaPixels: Area) => void;
        onInteractionStart?: () => void;
        onInteractionEnd?: () => void;
        style?: {
            containerStyle?: React.CSSProperties;
            mediaStyle?: React.CSSProperties;
            cropAreaStyle?: React.CSSProperties;
        };
        classes?: {
            containerClassName?: string;
            mediaClassName?: string;
            cropAreaClassName?: string;
        };
        restrictPosition?: boolean;
        mediaProps?: React.VideoHTMLAttributes<HTMLVideoElement> | React.ImgHTMLAttributes<HTMLImageElement>;
        disableAutomaticStylesInjection?: boolean;
        initialCroppedAreaPixels?: Area;
    }

    class Cropper extends Component<CropperProps> { }
    export default Cropper;
}
