import { NextRequest, NextResponse } from 'next/server'
import { auth } from '@/auth'
import { db } from '@/lib/db'
import { invoices } from '@/lib/db/schema'
import { eq, desc } from 'drizzle-orm'

export async function GET(req: NextRequest) {
    try {
        const session = await auth()
        if (!session || session.user.role !== 'admin') {
            return new NextResponse('Unauthorized', { status: 401 })
        }

        const pendingInvoices = await db.query.invoices.findMany({
            where: eq(invoices.status, 'pending'),
            with: {
                creator: true
            },
            orderBy: [desc(invoices.createdAt)]
        })

        return NextResponse.json(pendingInvoices)
    } catch (error) {
        console.error('[ADMIN_INVOICES_ERROR]', error)
        return new NextResponse('Internal Error', { status: 500 })
    }
}
