import { NextRequest, NextResponse } from 'next/server'
import { auth } from '@/auth'
import { db } from '@/lib/db'
import { creatorSocials, users } from '@/lib/db/schema'
import { eq, desc } from 'drizzle-orm'

export async function GET(req: NextRequest) {
    const session = await auth()
    if (!session || session.user.role !== 'admin') {
        return new NextResponse('Unauthorized', { status: 401 })
    }

    try {
        const pendingVerifications = await db.query.creatorSocials.findMany({
            where: eq(creatorSocials.verificationStatus, 'pending'),
            with: {
                creator: true
            },
            orderBy: [desc(creatorSocials.createdAt)]
        })

        return NextResponse.json(pendingVerifications)
    } catch (error) {
        console.error('Error fetching verifications:', error)
        return new NextResponse('Internal Server Error', { status: 500 })
    }
}
