import { NextResponse } from 'next/server'
import { authenticateRequest } from '@/lib/auth-middleware'
import { db } from '@/lib/db'
import { globalSettings } from '@/lib/db/schema'

export async function GET(request: Request) {
    try {
        const authResult = await authenticateRequest(request as any)
        if (!authResult.success) {
            return NextResponse.json({ error: 'Unauthorized' }, { status: 401 })
        }

        const settings = await db.select().from(globalSettings).limit(1)
        const s = settings[0] || {}

        return NextResponse.json({
            eur: {
                beneficiary: s.bankEurBeneficiary || 'SWIPLAY',
                iban: s.bankEurIban || 'FR76 ...',
                bic: s.bankEurBic || '...',
                bankName: s.bankEurBankName || '...',
                address: s.bankEurBankAddress || '...'
            },
            usd: {
                beneficiary: s.bankUsdBeneficiary || 'SWIPLAY INC',
                accountNumber: s.bankUsdAccountNumber || '...',
                routingNumber: s.bankUsdRoutingNumber || '...',
                bic: s.bankUsdBic || '...',
                bankName: s.bankUsdBankName || '...',
                address: s.bankUsdBankAddress || '...'
            }
        })
    } catch (error) {
        console.error('Error fetching bank details:', error)
        return NextResponse.json({ error: 'Internal Server Error' }, { status: 500 })
    }
}
