import { NextRequest, NextResponse } from 'next/server'
import { auth } from '@/auth'
import { db } from '@/lib/db'
import { creatorSocials } from '@/lib/db/schema'
import { eq } from 'drizzle-orm'

export async function GET(req: NextRequest) {
    const session = await auth()
    if (!session?.user?.id) return NextResponse.json({ error: 'Unauthorized' }, { status: 401 })

    try {
        const socials = await db.query.creatorSocials.findMany({
            where: eq(creatorSocials.creatorId, session.user.id)
        })

        return NextResponse.json({ socials })
    } catch (error) {
        console.error('Fetch Socials Error:', error)
        return NextResponse.json({ error: 'Failed to fetch socials' }, { status: 500 })
    }
}
