import { auth } from '@/auth'
import { db } from '@/lib/db'
import { users } from '@/lib/db/schema'
import { eq } from 'drizzle-orm'
import { NextResponse } from 'next/server'

export async function GET() {
    const session = await auth()
    if (!session || !session.user) {
        return new NextResponse('Unauthorized', { status: 401 })
    }

    const user = await db.query.users.findFirst({
        where: eq(users.id, session.user.id),
        columns: {
            onboardingComplete: true,
            isApproved: true
        }
    })

    if (!user) {
        return new NextResponse('User not found', { status: 404 })
    }

    return NextResponse.json(user)
}
