import { NextRequest, NextResponse } from 'next/server'
import { getInstagramFollowers, getYouTubeFollowers, getTikTokFollowers } from '@/lib/tracking/subscriber-tracker'
import { createApiResponse, handleApiError } from '@/lib/api-response'

export async function POST(request: NextRequest) {
    try {
        const body = await request.json()
        const { platform, handle } = body

        if (!platform || !handle) {
            return NextResponse.json({ error: 'Plateforme et pseudo requis' }, { status: 400 })
        }

        const cleanHandle = handle.replace('@', '').trim()

        if (!cleanHandle) {
            return NextResponse.json({ error: 'Pseudo invalide' }, { status: 400 })
        }

        let result: any = { success: false, error: 'Plateforme non supportée' }

        switch (platform.toLowerCase()) {
            case 'tiktok':
                result = await getTikTokFollowers(cleanHandle)
                break
            case 'instagram':
                result = await getInstagramFollowers(cleanHandle)
                break
            case 'youtube':
                result = await getYouTubeFollowers(cleanHandle)
                break
            default:
                return NextResponse.json({ error: 'Plateforme non supportée' }, { status: 400 })
        }

        if (result.success) {
            return createApiResponse({
                platform,
                handle: cleanHandle,
                followers: result.followers,
                formatted: result.formatted,
                avatar: result.avatar || null,
                verified: true
            })
        } else {
            return NextResponse.json(
                { error: result.error || 'Vérification échouée' },
                { status: 400 }
            )
        }
    } catch (error) {
        console.error('Verify Social Error:', error)
        return handleApiError(error)
    }
}
