import { NextRequest, NextResponse } from 'next/server'
import { auth } from '@/auth'
import { db } from '@/lib/db'
import { users } from '@/lib/db/schema'
import { eq } from 'drizzle-orm'

export async function GET(request: NextRequest) {
  try {
    const session = await auth()
    if (!session || session.user.role !== 'admin') {
      return NextResponse.json({ error: 'Non autorisé' }, { status: 401 })
    }

    const studios = await db.query.users.findMany({
      where: eq(users.role, 'studio'),
      orderBy: (users, { desc }) => [desc(users.createdAt)]
    })

    return NextResponse.json({ studios })
  } catch (error) {
    console.error('Error fetching studios:', error)
    return NextResponse.json({ error: 'Erreur serveur' }, { status: 500 })
  }
}
