import { NextRequest, NextResponse } from 'next/server'
import { db } from '@/lib/db'
import { payoutRequests } from '@/lib/db/schema'
import { authenticateRequest, requireRole } from '@/lib/auth-middleware'
import { desc } from 'drizzle-orm'

export async function GET(request: NextRequest) {
    try {
        const authResult = await authenticateRequest(request)
        if (!authResult.success) return NextResponse.json({ error: 'Unauthorized' }, { status: 401 })

        const roleCheck = requireRole(authResult.role, 'admin')
        if (!roleCheck.allowed) return NextResponse.json({ error: 'Forbidden' }, { status: 403 })

        const data = await db.query.payoutRequests.findMany({
            with: { creator: true },
            orderBy: [desc(payoutRequests.createdAt)]
        })

        return NextResponse.json(data)
    } catch {
        return NextResponse.json({ error: 'Internal Error' }, { status: 500 })
    }
}
