import { NextRequest, NextResponse } from 'next/server'
import { db } from '@/lib/db'
import { users } from '@/lib/db/schema'
import { eq } from 'drizzle-orm'

export async function GET(request: NextRequest) {
  try {
    // Get all approved creators
    const creators = await db
      .select()
      .from(users)
      .where(eq(users.role, 'creator'))
      .where(eq(users.isApproved, 1))

    return NextResponse.json({ creators })
  } catch (error) {
    console.error('Get creators error:', error)
    return NextResponse.json(
      { error: 'Erreur lors de la récupération des créateurs' },
      { status: 500 }
    )
  }
}
