'use client'

import Link from 'next/link'
import Image from 'next/image'

interface LandingFooterProps {
    locale?: string
}

const translations = {
    fr: {
        rights: 'Tous droits réservés.',
        terms: 'CGU',
        privacy: 'Confidentialité',
        legal: 'Mentions légales',
        question: 'Une question ?'
    },
    en: {
        rights: 'All rights reserved.',
        terms: 'Terms',
        privacy: 'Privacy',
        legal: 'Legal',
        question: 'Any questions?'
    }
}

export function LandingFooter({ locale = 'fr' }: LandingFooterProps) {
    const t = translations[locale as keyof typeof translations] || translations.fr

    return (
        <footer className="py-12 px-6 border-t border-white/10 bg-black text-white">
            <div className="max-w-5xl mx-auto flex flex-col md:flex-row items-center justify-between gap-6">
                <div className="flex items-center">
                    <span className="text-lg font-bold">SWIPL</span>
                    <Image src="/swiplay-logo.png" alt="A" width={14} height={14} className="-mx-0.5" />
                    <span className="text-lg font-bold">Y</span>
                    <span className="text-sm text-white/40 ml-3">© 2025 {t.rights}</span>
                </div>
                <div className="flex flex-col md:flex-row items-center gap-4 md:gap-6 text-sm text-white/40">
                    <div className="flex items-center gap-6">
                        <Link href="/legal/terms" className="hover:text-white transition-colors">{t.terms}</Link>
                        <Link href="/legal/privacy" className="hover:text-white transition-colors">{t.privacy}</Link>
                        <Link href="/legal/mentions" className="hover:text-white transition-colors">{t.legal}</Link>
                    </div>
                    <span className="text-white/20 hidden md:inline">|</span>
                    <span className="text-xs">{t.question} <a href="mailto:contact@swiplay.com" className="text-purple-400 hover:text-purple-300">contact@swiplay.com</a></span>
                </div>
            </div>
        </footer>
    )
}
