
'use client'

import { useState, useEffect } from 'react'
import { Slider } from '@/components/ui/slider'
import Image from 'next/image'
import { motion } from 'framer-motion'
import { ArrowLeft, ArrowRight } from 'lucide-react'

export function StudioStep1Builder({ locale }: { locale: string }) {
    const [budget, setBudget] = useState([10000])
    const [cpm, setCpm] = useState([4.0])
    const [views, setViews] = useState(0)

    useEffect(() => {
        setViews(Math.floor(budget[0] / cpm[0]) * 1000)
    }, [budget, cpm])

    const formatNumber = (num: number) => {
        if (num >= 1000000) return (num / 1000000).toFixed(1) + 'M'
        if (num >= 1000) return (num / 1000).toFixed(0) + 'K'
        return num.toString()
    }

    return (
        <div className="relative rounded-2xl bg-zinc-900/90 backdrop-blur-xl border border-white/10 shadow-2xl p-6 transform hover:scale-[1.02] transition-all duration-500">
            <div className="flex items-center gap-4 mb-6 pb-6 border-b border-white/10">
                <div className="w-16 h-16 rounded-xl bg-white/10 overflow-hidden relative">
                    <Image src="/images/campaigns/underarock_1.jpg" alt="Preview" fill className="object-cover" />
                </div>
                <div>
                    <h4 className="font-bold text-white">Under a Rock - Open Beta</h4>
                    <p className="text-sm text-white/50">Gameforge</p>
                </div>
            </div>

            <div className="space-y-8">
                {/* Budget Slider */}
                <div className="space-y-4">
                    <div className="flex justify-between items-end">
                        <label className="text-sm text-white/60 font-medium">
                            {locale === 'fr' ? 'Budget Global' : 'Global Budget'}
                        </label>
                        <span className="font-bold text-white text-lg">€{budget[0].toLocaleString()}</span>
                    </div>
                    <Slider
                        value={budget}
                        onValueChange={setBudget}
                        max={50000}
                        min={1000}
                        step={500}
                        className="w-full"
                    />
                    <div className="flex justify-between text-xs text-white/30">
                        <span>€1k</span>
                        <span>€50k</span>
                    </div>
                </div>

                {/* CPM Slider */}
                <div className="space-y-4">
                    <div className="flex justify-between items-end">
                        <label className="text-sm text-white/60 font-medium">
                            CPM <span className="text-xs text-white/30 font-normal">({locale === 'fr' ? 'Coût par 1k vues' : 'Cost per 1k views'})</span>
                        </label>
                        <span className="font-bold text-purple-400 text-lg">€{cpm[0].toFixed(2)}</span>
                    </div>
                    <Slider
                        value={cpm}
                        onValueChange={setCpm}
                        max={20}
                        min={4}
                        step={0.5}
                        className="w-full"
                    />
                    <div className="flex justify-between text-xs text-white/30">
                        <span>€4</span>
                        <span>€20</span>
                    </div>
                </div>

                {/* Estimation Card */}
                <div className="p-4 rounded-xl bg-gradient-to-r from-blue-500/10 to-purple-500/10 border border-blue-500/20">
                    <div className="text-center">
                        <p className="text-xs text-white/50 mb-1">{locale === 'fr' ? 'Estimation' : 'Estimated Views'}</p>
                        <p className="text-3xl font-bold bg-clip-text text-transparent bg-gradient-to-r from-blue-400 to-purple-400">
                            ~{formatNumber(views)}
                        </p>
                    </div>
                </div>
            </div>
        </div>
    )
}
