'use client'

import { ReactNode } from 'react'
import { Sidebar } from './Sidebar'

interface NavItem {
    iconName: string
    label: string
    href: string
}

interface DashboardLayoutProps {
    children: ReactNode
    navItems: NavItem[]
    role: 'creator' | 'studio' | 'admin'
    user?: { name?: string | null; email?: string | null; image?: string | null }
    showSidebar?: boolean
}

import { usePathname } from 'next/navigation'

export function DashboardLayout({ children, navItems, role, user, showSidebar = true }: DashboardLayoutProps) {
    const pathname = usePathname()
    const isHidden = !showSidebar || pathname.includes('/onboarding')

    if (isHidden) {
        return <div className="min-h-screen">{children}</div>
    }

    return (
        <div className="min-h-screen">
            <Sidebar items={navItems} role={role} user={user} />

            {/* Main content */}
            <main className="md:pl-64">
                <div className="min-h-screen p-6 md:p-8">
                    {children}
                </div>
            </main>
        </div>
    )
}
