// Utility functions and types for bank details
// Actual bank details are stored in database (globalSettings table)

export interface BankDetailsEUR {
    beneficiary: string
    iban: string
    bic: string
    bankName: string
    bankAddress: string
}

export interface BankDetailsUSD {
    beneficiary: string
    accountNumber: string
    routingNumber: string
    bic: string
    accountType: string
    bankName: string
    bankAddress: string
}

export interface BankDetails {
    EUR: BankDetailsEUR
    USD: BankDetailsUSD
}

export type Currency = 'EUR' | 'USD'

// Generate unique payment reference
export function generatePaymentReference(campaignId: string): string {
    return `SWI-${campaignId.slice(0, 8).toUpperCase()}`
}

// Format amount by currency
export function formatAmountByCurrency(amount: number, currency: Currency): string {
    const formatter = new Intl.NumberFormat(currency === 'EUR' ? 'fr-FR' : 'en-US', {
        style: 'currency',
        currency
    })
    return formatter.format(amount)
}
