// Game Tags Configuration - EN + FR
// Used for campaign categorization

export const GAME_TAGS = {
    // Gameplay Type
    multiplayer: { en: 'Multiplayer', fr: 'Multijoueur' },
    solo: { en: 'Solo', fr: 'Solo' },
    coop: { en: 'Co-op', fr: 'Coopératif' },
    pvp: { en: 'PvP', fr: 'JcJ' },
    pve: { en: 'PvE', fr: 'JcE' },
    mmo: { en: 'MMO', fr: 'MMO' },
    battle_royale: { en: 'Battle Royale', fr: 'Battle Royale' },

    // Genre
    action: { en: 'Action', fr: 'Action' },
    adventure: { en: 'Adventure', fr: 'Aventure' },
    rpg: { en: 'RPG', fr: 'RPG' },
    fps: { en: 'FPS', fr: 'FPS' },
    tps: { en: 'TPS', fr: 'TPS' },
    strategy: { en: 'Strategy', fr: 'Stratégie' },
    puzzle: { en: 'Puzzle', fr: 'Puzzle' },
    simulation: { en: 'Simulation', fr: 'Simulation' },
    sports: { en: 'Sports', fr: 'Sports' },
    racing: { en: 'Racing', fr: 'Course' },
    horror: { en: 'Horror', fr: 'Horreur' },
    survival: { en: 'Survival', fr: 'Survie' },
    roguelike: { en: 'Roguelike', fr: 'Roguelike' },
    roguelite: { en: 'Roguelite', fr: 'Roguelite' },
    platformer: { en: 'Platformer', fr: 'Plateforme' },
    fighting: { en: 'Fighting', fr: 'Combat' },
    sandbox: { en: 'Sandbox', fr: 'Bac à sable' },
    open_world: { en: 'Open World', fr: 'Monde ouvert' },
    metroidvania: { en: 'Metroidvania', fr: 'Metroidvania' },
    souls_like: { en: 'Souls-like', fr: 'Souls-like' },

    // Style
    indie: { en: 'Indie', fr: 'Indé' },
    aaa: { en: 'AAA', fr: 'AAA' },
    retro: { en: 'Retro', fr: 'Rétro' },
    pixel_art: { en: 'Pixel Art', fr: 'Pixel Art' },
    realistic: { en: 'Realistic', fr: 'Réaliste' },
    cartoon: { en: 'Cartoon', fr: 'Cartoon' },
    anime: { en: 'Anime', fr: 'Anime' },

    // Theme
    fantasy: { en: 'Fantasy', fr: 'Fantasy' },
    sci_fi: { en: 'Sci-Fi', fr: 'Science-Fiction' },
    medieval: { en: 'Medieval', fr: 'Médiéval' },
    post_apocalyptic: { en: 'Post-Apocalyptic', fr: 'Post-Apocalyptique' },
    cyberpunk: { en: 'Cyberpunk', fr: 'Cyberpunk' },
    steampunk: { en: 'Steampunk', fr: 'Steampunk' },
    military: { en: 'Military', fr: 'Militaire' },
    western: { en: 'Western', fr: 'Western' },

    // Audience
    casual: { en: 'Casual', fr: 'Casual' },
    hardcore: { en: 'Hardcore', fr: 'Hardcore' },
    family_friendly: { en: 'Family Friendly', fr: 'Tout public' },
    mature: { en: 'Mature', fr: 'Mature' },

    // Platform hints
    mobile: { en: 'Mobile', fr: 'Mobile' },
    pc: { en: 'PC', fr: 'PC' },
    console: { en: 'Console', fr: 'Console' },
    vr: { en: 'VR', fr: 'VR' },
    cross_platform: { en: 'Cross-Platform', fr: 'Cross-Plateforme' },
} as const

export type GameTagKey = keyof typeof GAME_TAGS

// Helper to get localized tag name
export function getTagLabel(tag: GameTagKey, locale: 'en' | 'fr'): string {
    return GAME_TAGS[tag]?.[locale] || tag
}

// Get all tags as options for select/multiselect
export function getTagOptions(locale: 'en' | 'fr'): { value: GameTagKey; label: string }[] {
    return Object.entries(GAME_TAGS).map(([key, labels]) => ({
        value: key as GameTagKey,
        label: labels[locale]
    }))
}

// Group tags by category
export const TAG_CATEGORIES = {
    gameplay: ['multiplayer', 'solo', 'coop', 'pvp', 'pve', 'mmo', 'battle_royale'],
    genre: ['action', 'adventure', 'rpg', 'fps', 'tps', 'strategy', 'puzzle', 'simulation', 'sports', 'racing', 'horror', 'survival', 'roguelike', 'roguelite', 'platformer', 'fighting', 'sandbox', 'open_world', 'metroidvania', 'souls_like'],
    style: ['indie', 'aaa', 'retro', 'pixel_art', 'realistic', 'cartoon', 'anime'],
    theme: ['fantasy', 'sci_fi', 'medieval', 'post_apocalyptic', 'cyberpunk', 'steampunk', 'military', 'western'],
    audience: ['casual', 'hardcore', 'family_friendly', 'mature'],
    platform: ['mobile', 'pc', 'console', 'vr', 'cross_platform'],
} as const

export const CATEGORY_LABELS = {
    gameplay: { en: 'Gameplay', fr: 'Gameplay' },
    genre: { en: 'Genre', fr: 'Genre' },
    style: { en: 'Style', fr: 'Style' },
    theme: { en: 'Theme', fr: 'Thème' },
    audience: { en: 'Audience', fr: 'Audience' },
    platform: { en: 'Platform', fr: 'Plateforme' },
} as const
