// Predefined game tags with translations
export const GAME_TAGS = {
    // Gameplay
    solo: { en: 'Solo', fr: 'Solo' },
    multiplayer: { en: 'Multiplayer', fr: 'Multijoueur' },
    coop: { en: 'Co-op', fr: 'Coopératif' },
    pvp: { en: 'PvP', fr: 'PvP' },
    mmo: { en: 'MMO', fr: 'MMO' },

    // Genres
    action: { en: 'Action', fr: 'Action' },
    adventure: { en: 'Adventure', fr: 'Aventure' },
    rpg: { en: 'RPG', fr: 'RPG' },
    fps: { en: 'FPS', fr: 'FPS' },
    horror: { en: 'Horror', fr: 'Horreur' },
    survival: { en: 'Survival', fr: 'Survie' },
    roguelike: { en: 'Roguelike', fr: 'Roguelike' },
    roguelite: { en: 'Roguelite', fr: 'Roguelite' },
    puzzle: { en: 'Puzzle', fr: 'Puzzle' },
    platformer: { en: 'Platformer', fr: 'Plateformes' },
    racing: { en: 'Racing', fr: 'Course' },
    sports: { en: 'Sports', fr: 'Sport' },
    simulation: { en: 'Simulation', fr: 'Simulation' },
    strategy: { en: 'Strategy', fr: 'Stratégie' },
    fighting: { en: 'Fighting', fr: 'Combat' },
    shooter: { en: 'Shooter', fr: 'Tir' },
    sandbox: { en: 'Sandbox', fr: 'Bac à sable' },
    openworld: { en: 'Open World', fr: 'Monde Ouvert' },

    // Style
    indie: { en: 'Indie', fr: 'Indé' },
    aaa: { en: 'AAA', fr: 'AAA' },
    retro: { en: 'Retro', fr: 'Rétro' },
    pixelart: { en: 'Pixel Art', fr: 'Pixel Art' },

    // Atmosphere
    relaxing: { en: 'Relaxing', fr: 'Relaxant' },
    challenging: { en: 'Challenging', fr: 'Difficile' },
    story: { en: 'Story-Rich', fr: 'Riche en Histoire' },
    casual: { en: 'Casual', fr: 'Casual' },
    competitive: { en: 'Competitive', fr: 'Compétitif' },
} as const

export type GameTagKey = keyof typeof GAME_TAGS

export function getTagLabel(tag: string, locale: 'en' | 'fr' = 'fr'): string {
    const tagData = GAME_TAGS[tag as GameTagKey]
    if (tagData) {
        return tagData[locale]
    }
    // Fallback: capitalize the tag
    return tag.charAt(0).toUpperCase() + tag.slice(1)
}

export function getAllTags(locale: 'en' | 'fr' = 'fr'): { value: string; label: string }[] {
    return Object.entries(GAME_TAGS).map(([key, translations]) => ({
        value: key,
        label: translations[locale]
    }))
}
