import { z } from 'zod'

export const campaignSchema = z.object({
    title: z.string().min(3, 'Le titre doit faire au moins 3 caractères'),
    description: z.string().min(10, 'La description doit faire au moins 10 caractères'),
    budget: z.number().positive('Le budget doit être positif'),
    pricePerView: z.number().positive('Le prix par vue doit être positif'),
    coverImage: z.string().url('L\'image de couverture doit être une URL valide').optional().or(z.literal('')),
    icon: z.string().url('L\'icône doit être une URL valide').optional().or(z.literal('')),
    startDate: z.string().optional(),
    endDate: z.string().optional(),
})

export const userSettingsSchema = z.object({
    notifications: z.object({
        email: z.boolean().optional(),
        newCampaigns: z.boolean().optional(),
        submissionStatus: z.boolean().optional(),
        payments: z.boolean().optional(),
        marketing: z.boolean().optional(),
    }).optional(),
    privacy: z.object({
        profileVisible: z.boolean().optional(),
        statsVisible: z.boolean().optional(),
    }).optional(),
    payout: z.object({
        bankName: z.string().optional(),
        iban: z.string().optional(),
        bic: z.string().optional(),
        paypalEmail: z.string().email().optional().or(z.literal('')),
        currency: z.string().optional(),
        accountNumber: z.string().optional(),
        routingNumber: z.string().optional(),
        bankAddress: z.string().optional(),
    }).optional(),
    billing: z.object({
        firstName: z.string().optional(),
        lastName: z.string().optional(),
        address: z.string().optional(),
        city: z.string().optional(),
        zip: z.string().optional(),
        country: z.string().optional(),
    }).optional(),
    general: z.object({
        discordHandle: z.string().optional(),
        locale: z.string().optional(),
    }).optional(),
})

export const authSchema = z.object({
    email: z.string().email('Email invalide'),
    role: z.enum(['studio', 'creator']).optional(),
})
