export function validateSocialLink(url: string, platform: string): boolean {
    try {
        const urlObj = new URL(url)
        const hostname = urlObj.hostname.toLowerCase()

        switch (platform) {
            case 'tiktok':
                return (
                    (hostname.includes('tiktok.com')) &&
                    /\/video\/\d+/.test(urlObj.pathname)
                )
            case 'instagram':
                return (
                    (hostname.includes('instagram.com')) &&
                    (urlObj.pathname.includes('/p/') || urlObj.pathname.includes('/reel/'))
                )
            case 'youtube':
                return (
                    (hostname.includes('youtube.com') || hostname.includes('youtu.be')) &&
                    (
                        urlObj.pathname.includes('/watch') ||
                        urlObj.pathname.includes('/shorts/') ||
                        hostname === 'youtu.be'
                    )
                )
            default:
                return false
        }
    } catch (e) {
        return false
    }
}
