const { Pool } = require('pg');
require('dotenv').config({ path: '.env' });

const pool = new Pool({
    connectionString: process.env.DATABASE_URL,
});

async function addLegalCertifiedColumn() {
    try {
        const client = await pool.connect();
        console.log('Connected to database');

        try {
            console.log('Checking if legal_certified column exists in submissions table...');
            const checkRes = await client.query(`
        SELECT column_name 
        FROM information_schema.columns 
        WHERE table_name='submissions' AND column_name='legal_certified';
      `);

            if (checkRes.rows.length === 0) {
                console.log('Column legal_certified does not exist. Adding it...');
                await client.query(`
          ALTER TABLE submissions 
          ADD COLUMN legal_certified BOOLEAN DEFAULT FALSE;
        `);
                console.log('Successfully added legal_certified column to submissions table.');
            } else {
                console.log('Column legal_certified already exists.');
            }

        } finally {
            client.release();
        }
    } catch (err) {
        console.error('Error executing script:', err);
    } finally {
        await pool.end();
    }
}

addLegalCertifiedColumn();
