const { Pool } = require('pg');
require('dotenv').config({ path: '.env' });

const pool = new Pool({
    connectionString: process.env.DATABASE_URL,
});

async function addTermsAcceptedColumn() {
    try {
        const client = await pool.connect();
        console.log('Connected to database');

        try {
            console.log('Checking if terms_accepted column exists in users table...');
            const checkRes = await client.query(`
        SELECT column_name 
        FROM information_schema.columns 
        WHERE table_name='users' AND column_name='terms_accepted';
      `);

            if (checkRes.rows.length === 0) {
                console.log('Column terms_accepted does not exist. Adding it...');
                await client.query(`
          ALTER TABLE users 
          ADD COLUMN terms_accepted BOOLEAN DEFAULT FALSE;
        `);
                console.log('Successfully added terms_accepted column to users table.');
            } else {
                console.log('Column terms_accepted already exists.');
            }

        } finally {
            client.release();
        }
    } catch (err) {
        console.error('Error executing script:', err);
    } finally {
        await pool.end();
    }
}

addTermsAcceptedColumn();
