
import { db } from '@/lib/db'
import { users } from '@/lib/db/schema'
import { eq } from 'drizzle-orm'

async function main() {
    const userId = process.argv[2]
    if (!userId) {
        console.error('Please provide a user ID')
        process.exit(1)
    }

    console.log(`Deleting user ${userId}...`)

    try {
        await db.delete(users).where(eq(users.id, userId))
        console.log('User deleted successfully')
    } catch (error) {
        console.error('Error deleting user:', error)
        process.exit(1)
    }

    process.exit(0)
}

main().catch(console.error)
