
import fetch from 'node-fetch';
import fs from 'fs';

const DOC_ID = '8845758582119845';
const URL = 'https://www.instagram.com/graphql/query';

// Helper to load session
function getSession() {
    try {
        return JSON.parse(fs.readFileSync('session.json', 'utf-8'));
    } catch (e) {
        console.error('❌ Error: session.json not found. Run "npx tsx scripts/get-session.ts" first.');
        process.exit(1);
    }
}

async function getReelStats(shortcode: string) {
    const session = getSession();
    const variables = { shortcode };
    const params = new URLSearchParams();
    params.append('doc_id', DOC_ID);
    params.append('variables', JSON.stringify(variables));

    try {
        const startTime = Date.now();
        const res = await fetch(URL, {
            method: 'POST',
            headers: {
                'Content-Type': 'application/x-www-form-urlencoded',
                'User-Agent': 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36',
                ...session.headers
            },
            body: params
        });

        if (res.status !== 200) {
            throw new Error(`API returned status ${res.status}`);
        }

        const json = await res.json();
        const media = json.data?.xdt_shortcode_media;

        if (media) {
            console.log(JSON.stringify({
                shortcode,
                view_count: media.video_view_count,
                play_count: media.video_play_count,
                likes: media.edge_media_preview_like?.count,
                duration: (Date.now() - startTime) / 1000
            }, null, 2));
        } else {
            console.error('❌ Media not found in response.');
        }

    } catch (error: any) {
        console.error(`Error: ${error.message}`);
    }
}

// Get shortcode from args or default
const shortcode = process.argv[2] || 'DQXLRfljOGH';
getReelStats(shortcode);
