
import { db } from '@/lib/db'
import { users, creatorSocials } from '@/lib/db/schema'
import { eq, ilike } from 'drizzle-orm'

async function main() {
    console.log('Searching for user with YouTube channel "eyzuro"...')

    const social = await db.query.creatorSocials.findFirst({
        where: (socials, { and, eq, ilike }) => and(
            eq(socials.platform, 'youtube'),
            ilike(socials.handle, '%eyzuro%')
        ),
        with: {
            creator: true
        }
    })

    if (social) {
        console.log('Found social connection:', social)
        console.log('User to delete:', social.creator)
        console.log(`To delete, run: pnpm tsx scripts/delete_user.ts ${social.creatorId}`)
    } else {
        console.log('No social connection found for "eyzuro"')

        // Try searching email
        const user = await db.query.users.findFirst({
            where: (users, { ilike }) => ilike(users.email, '%eyzuro%')
        })

        if (user) {
            console.log('Found user by email:', user)
        }
    }

    process.exit(0)
}

main().catch(console.error)
