const { Client } = require('pg');
require('dotenv').config();

const dbUrl = process.env.DATABASE_URL;

if (!dbUrl) {
    console.error("❌ DATABASE_URL is not set in .env");
    process.exit(1);
}

const client = new Client({
    connectionString: dbUrl,
});

async function run() {
    try {
        await client.connect();
        console.log("✅ Connected to database");

        // Add privacy_policy_accepted column
        try {
            await client.query(`
                ALTER TABLE "users" 
                ADD COLUMN IF NOT EXISTS "privacy_policy_accepted" boolean DEFAULT false;
            `);
            console.log("✅ Added 'privacy_policy_accepted' column to 'users' table");
        } catch (e) {
            console.log("⚠️ Error adding 'privacy_policy_accepted' column (might already exist):", e.message);
        }

    } catch (err) {
        console.error("❌ Database connection error:", err);
    } finally {
        await client.end();
    }
}

run();
