
import puppeteer from 'puppeteer';
import fs from 'fs';

async function run() {
    console.log('--- Fetching Session Cookies ---');
    const browser = await puppeteer.launch({
        headless: true,
        args: ['--no-sandbox', '--disable-setuid-sandbox', '--disable-dev-shm-usage', '--disable-accelerated-2d-canvas', '--disable-gpu']
    });

    try {
        const page = await browser.newPage();
        await page.setUserAgent('Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36');

        // Go to a public page to get initial cookies
        await page.goto('https://www.instagram.com/eyzuro/', { waitUntil: 'networkidle2' });

        // Get cookies
        const cookies = await page.cookies();

        // Get CSRF token from cookies or page evaluation
        const csrftoken = cookies.find(c => c.name === 'csrftoken')?.value || '';
        const mid = cookies.find(c => c.name === 'mid')?.value || '';
        const ig_did = cookies.find(c => c.name === 'ig_did')?.value || '';

        const session = {
            cookies,
            headers: {
                'x-csrftoken': csrftoken,
                'x-ig-app-id': '936619743392459',
                'cookie': cookies.map(c => `${c.name}=${c.value}`).join('; ')
            }
        };

        fs.writeFileSync('session.json', JSON.stringify(session, null, 2));
        console.log('✅ Saved session.json');

    } catch (error: any) {
        console.error(`Error: ${error.message}`);
    } finally {
        await browser.close();
    }
}

run();
