import { drizzle } from 'drizzle-orm/node-postgres'
import { Pool } from 'pg'
import * as schema from '@/lib/db/schema'
import { accounts } from '@/lib/db/schema'
import { eq } from 'drizzle-orm'

const connectionString = 'postgresql://postgres:q6%3B4GZzP1Eb.l8@localhost:5432/swiplay_v3'

const pool = new Pool({ connectionString })
const db = drizzle(pool, { schema })

async function main() {
    console.log('Checking Google accounts...')
    const googleAccounts = await db.select().from(accounts).where(eq(accounts.provider, 'google'))

    if (googleAccounts.length === 0) {
        console.log('No Google accounts found.')
    }

    googleAccounts.forEach(a => {
        console.log(`UserId: ${a.userId}, Provider: ${a.provider}, AccessToken: ${a.access_token ? 'YES' : 'NO'}, RefreshToken: ${a.refresh_token ? 'YES' : 'NO'}, ExpiresAt: ${a.expires_at}`)
    })
}

main().catch(console.error).finally(async () => {
    await pool.end()
    process.exit(0)
})
