
import axios from 'axios';
import * as cheerio from 'cheerio';

async function test() {
    const username = 'mohahnz';
    console.log(`Testing Instagram Embed Scraper for ${username}...`);

    const urls = [
        `https://www.instagram.com/${username}/embed`,
        `https://www.instagram.com/${username}/embed/captioned/`,
        `https://www.instagram.com/${username}/`, // With specific headers
    ];

    for (const url of urls) {
        try {
            console.log(`\nFetching ${url}...`);
            const response = await axios.get(url, {
                headers: {
                    'User-Agent': 'Mozilla/5.0 (compatible; Googlebot/2.1; +http://www.google.com/bot.html)',
                    // 'User-Agent': 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36',
                },
                timeout: 10000,
                validateStatus: () => true
            });

            console.log(`Status: ${response.status}`);
            if (response.status === 200) {
                const html = response.data;
                // console.log('HTML Preview:', html.substring(0, 500));

                // Look for follower count in meta tags
                const metaDesc = html.match(/<meta\s+content="([^"]*)"\s+name="description"/i) ||
                    html.match(/<meta\s+name="description"\s+content="([^"]*)"/i) ||
                    html.match(/property="og:description"\s+content="([^"]*)"/i);

                if (metaDesc) {
                    console.log('Meta Description Found:', metaDesc[1]);
                    // Extract number
                    const followersMatch = metaDesc[1].match(/([0-9,.]+[KMB]?)\s*Followers/i);
                    if (followersMatch) {
                        console.log('SUCCESS! Followers:', followersMatch[1]);
                    }
                } else {
                    console.log('No meta description found.');
                }
            }
        } catch (error) {
            console.error(`Error fetching ${url}:`, error.message);
        }
    }
}

test();
